<?php
	require_once('php/startup.inc.php');

	$startingDate = date('Y-m-d');		// Use a $_GET parameter to pass in a different starting date
?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset='utf-8' />
		<link href='../lib/cupertino/jquery-ui.min.css' rel='stylesheet' />
		<link href='../fullcalendar.css' rel='stylesheet' />
		<link href='../fullcalendar.print.css' rel='stylesheet' media='print' />
		<script src='../lib/moment.min.js'></script>
		<script src='../lib/jquery.min.js'></script>
		<script src='../lib/jquery-ui.custom.min.js'></script>
		<script src='../fullcalendar.min.js'></script>
		<script>

			$(document).ready(function() {

				$('#calendar').fullCalendar({
					theme: true,
					header: {
						left: 'prev,next today',
						center: 'title',
						right: 'month,agendaWeek,agendaDay'
					},
					defaultDate: '<?php echo $startingDate; ?>',
					editable: false,
					weekMode: 'variable',

					eventSources: [
						{ url: 'php/projects.ajax.php' },
						{ url: 'php/holidays.ajax.php' }
					],


					eventClick: function(event, jsEvent, view) {
						window.location.href = "<?php echo 'fmp://'. FM_HOST .'/'. FM_DATABASE .'.fmp12?script='. FM_PROJECT_CLICK_SCRIPT .'&param='; ?>"+ event.id;
					},

					loading: function(bool) {
						$('#loading').toggle(bool);
					}
				});
			});

		</script>
		<style>

			body {
				margin: 0;
				padding: 0;
				font-family: "Helvetica Neue",Helvetica,Arial,Verdana,sans-serif;
				font-size: 14px;
			}

			#calendar {
				width: 900px;
				margin: 10px auto;
			}

			#loading {
				position: absolute; top: 20x; right: 30px;
			}

		</style>
	</head>

	<body>
		<div id='loading' style='display:none'><img src="img/ajax-loader.gif" height="11" width="43"></div>

		<div id='calendar'></div>

	</body>
	</html>
